// ===============================================
// utils.js
// Funcții mici și utile, folosite peste tot.
// ===============================================

window.$ = (sel, parent = document) => parent.querySelector(sel);
window.$$ = (sel, parent = document) => Array.from(parent.querySelectorAll(sel));

window.Utils = {
    // Formatăm un Date/ISO în YYYY-MM-DD HH:MM:SS
    formatDateTime(date) {
        const d = (date instanceof Date) ? date : new Date(date);
        const pad = (n) => String(n).padStart(2, "0");

        return `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())} ` +
               `${pad(d.getHours())}:${pad(d.getMinutes())}:${pad(d.getSeconds())}`;
    },

    // Debounce pentru input de căutare etc.
    debounce(fn, delay = 300) {
        let t;
        return (...args) => {
            clearTimeout(t);
            t = setTimeout(() => fn(...args), delay);
        };
    }
};
