// ===============================================
// panel.js
// Controlează panoul de detalii (lead / client / task).
// ===============================================

window.Panel = {
    open(type, data) {
        // Încarcă template-ul panel-ului odată, dacă nu e încă
        const panel = document.querySelector(".details-panel");
        if (!panel) {
            console.warn("Nu există .details-panel în DOM.");
            return;
        }

        // Aici tu mapezi câmpurile (nume, email, status etc.)
        panel.classList.add("open");

        // Exemplu simplu:
        const titleEl = panel.querySelector(".details-title");
        const subtitleEl = panel.querySelector(".details-subtitle");

        if (titleEl) titleEl.textContent = data.name || data.title || "(fără nume)";
        if (subtitleEl) subtitleEl.textContent = type === "lead" ? "Lead" : type;

        // TODO: completează restul câmpurilor conform layout-ului tău
    },

    close() {
        const panel = document.querySelector(".details-panel");
        if (panel) panel.classList.remove("open");
    }
};
