// ===============================================
// events.js
// Centralizează event-urile globale:
// - buton tema
// - căutare globală
// - notificări (placeholder)
// ===============================================

window.Events = {
    initGlobalEvents() {
        this.bindThemeToggle();
        this.bindGlobalSearch();
    },

    bindThemeToggle() {
        const btn = document.getElementById("btnTheme");
        if (!btn) return;

        btn.addEventListener("click", () => {
            UI.toggleTheme();
        });
    },

    bindGlobalSearch() {
        const input = document.getElementById("globalSearch");
        if (!input) return;

        input.addEventListener("input", Utils.debounce((e) => {
            const value = e.target.value.trim();
            // Pe viitor: căutare globală în leaduri/clienți/taskuri
            console.log("Global search:", value);
        }, 400));
    }
};
