// ===============================================
// app.js
// Punctul principal de inițializare al CRM-ului.
// - încarcă header + sidebar
// - pornește router-ul
// - setează tema
// ===============================================

window.App = {
    initialized: false,

    async init() {
        if (this.initialized) return;
        this.initialized = true;

        // 1. Inițializăm tema (dark / light)
        UI.initTheme();

        // 2. Încărcăm header + sidebar (componente HTML)
        await this.loadShell();

        // 3. Inițializăm router-ul (navigare pagini)
        Router.init();

        // 4. Event-uri globale (ex: butoane din header)
        Events.initGlobalEvents();

        // 5. Navigăm implicit la pagina de leaduri
        Router.navigate("leads");
    },

    async loadShell() {
        // Încarcă header-ul
        const headerEl = document.getElementById("app-header");
        const sidebarEl = document.getElementById("app-sidebar");

        const [headerHtml, sidebarHtml] = await Promise.all([
            fetch("components/header.html").then(r => r.text()),
            fetch("components/sidebar.html").then(r => r.text())
        ]);

        headerEl.innerHTML = headerHtml;
        sidebarEl.innerHTML = sidebarHtml;
    }
};
